//---- INITIAL VARIABLES
_root.videoController = {}; //- object to hold all video controlling objects in
_root.videoController.playheadInDrag = false;
_root.videoController.playState = "notLoaded"; //- values later: playing, paused, wasPlaying
_root.progressBarWidth = 386;
_root.progressBarStartX = 103;



//---- VIDEO FUNCTIONS
// Load video function
_root.loadVideo = function (clipToLoad) {
    // New net connection and stream connection
    my_nc = new NetConnection();
    my_nc.connect(null);
    _root.netStream = new NetStream(my_nc);
    _root.netStream.setBufferTime(2);
    
    // Attach and play the video
    _root.videoContainer.attachVideo(_root.netStream);
    _root.netStream.play(clipToLoad);
    _root.videoController.playState = "playing";
    _root.videoController.clip = _root.netStream;


    // Attach the audio to a new clip
    _root.createEmptyMovieClip("audio_mc", _root.getNextHighestDepth());
    _root.audio_mc.attachAudio(_root.netStream);
    _root.flv_audio = new Sound(audio_mc);
    _root.flv_audio.setVolume(100);

    // Extract the metadata
    _root.netStream.onMetaData = function(ojb) {
        _root.videoController.duration = ojb.duration;
    }

    // Save status
    _root.videoController.playState = "playing";
    
    // Set continual update
    _root.continualUpdate = setInterval(updateVideo, 100);
};


// Update video function
_root.updateVideo = function() {
    // Show amount loaded
    var amountLoaded = _root.netStream.bytesLoaded / _root.netStream.bytesTotal; //- A percentage; 0.0 to 1.0
    _root.loadBar._width = amountLoaded * _root.progressBarWidth;    

    // Move playhead if not dragging
    if (!_root.videoController.playheadInDrag) {
        var amountPlayed = _root.netStream.time / _root.videoController.duration;
        _root.playHead._x = _root.progressBarStartX + (amountPlayed * _root.progressBarWidth);
    }

}

// Pause button
_root.pauseButton.onRelease = function() {
    // Currently pause only ever pauses - never unpauses
    var vc = _root.videoController;
    
    if (vc.playState == "playing") {
        vc.playState = "paused";
        trace("Paused");
    } else {
        vc.playState = "paused";
        trace("Paused");
    }
    _root.netStream.pause(true);
}


// Play button
_root.playButton.onRelease = function() {
    // Currently play only ever plays - never pauses
    var vc = _root.videoController;

    if (vc.playState == "playing") {
        _root.netStream.pause(false);
        vc.playState = "playing";
        trace("Playing");
    } else {
        _root.netStream.pause(false);
        vc.playState = "playing";
        trace("Playing");
    }
}

// Playhead scrubbing
_root.beginVideoScrub = function() {
    // Activate scrubbing
    _root.playheadInDrag = true;
    // Kill the sound..
    var vc = _root.contentMC.workArea.videoComponents.videoController;
    if (vc.status == "playing") {
        _root.netStream.pause();
        vc.status = "wasplaying"; //- we were playing before dragging
    }
    trace("playhead hit");
    
    // Enterframe stuff
    _root.contentMC.workArea.videoComponents.videoController.playhead.onEnterFrame = function() {
        if (_root.playheadInDrag) {

            // Get the duration, time, and calculate % scrolled
            var duration = _root.contentMC.workArea.videoComponents.videoController.duration;
            var time = _root.contentMC.workArea.videoComponents.videoController.clip.time;
            var percentage = (_root.contentMC.workArea.videoComponents.videoController.playhead._x - 60) / 412;

                // Seek the correct time - from the PREVIOUS point because it usually ends up jumping forward
            var seekTime = duration * percentage - 1;
            if (seekTime < 0) {
                seekTime = 0;
            }
            _root.contentMC.workArea.videoComponents.videoController.clip.seek(seekTime);
        } else {
            // End the function
            delete _root.contentMC.workArea.videoComponents.videoController.playhead.onEnterFrame;
        }
    }
}

// Playbar click jump to
function playbarJump(xClick) {
    // Correct for 10px subtraction to centre the playhead
    xClick = xClick - 10;
    if (xClick < 60) {
        xClick = 60;
    } else if (xClick > 460) {
        xClick = 460;
    }
    
    // Calculate the duration, time, percentage of where this point is at
    var duration = _root.contentMC.workArea.videoComponents.videoController.duration;
    var time = _root.contentMC.workArea.videoComponents.videoController.clip.time;
    var percentage = (xClick - 60) / 422;

    // Seek the correct time - from the PREVIOUS point because it usually ends up jumping forward
    var seekTime = duration * percentage - 1;
    if (seekTime < 0) {
        seekTime = 0;
    }
    _root.contentMC.workArea.videoComponents.videoController.clip.seek(seekTime);
    
    // Move the playhead to that point
    trace("Playhead moved!");

}



//---- BEGIN PLAYBACK
if (_root.file) {
    clipToLoad = _root.file;
} else {
    clipToLoad = "ninja-200.flv";
    clipToLoad = "http://www.switch.tv/content/ninja-200.flv";
}

_root.loadVideo(clipToLoad);